/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.data.api;

import com.google.common.collect.Sets;
import de.codecrafter47.data.api.DataHolder;
import de.codecrafter47.data.api.DataKey;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DataCache
implements DataHolder {
    private final Map<DataKey<?>, Object> cache = new ConcurrentHashMap();
    private final Map<DataKey<?>, ListenerMapEntry> listenerMap = new ConcurrentHashMap();

    public <T> void updateValue(DataKey<T> dataKey, T object) {
        if (object == null) {
            this.cache.remove(dataKey);
        } else {
            this.cache.put(dataKey, object);
        }
        ListenerMapEntry entry = this.listenerMap.get(dataKey);
        Object error = null;
        if (entry != null) {
            entry.isNotifyingListeners = true;
            for (Runnable listener : entry.listeners) {
                try {
                    if (entry.listenersRemoved.contains(listener)) continue;
                    listener.run();
                }
                catch (Throwable th) {
                    if (error == null) {
                        error = new AssertionError("Failed to run listener", th);
                        continue;
                    }
                    ((Throwable)error).addSuppressed(th);
                }
            }
            entry.listeners.removeAll(entry.listenersRemoved);
            entry.listeners.addAll(entry.listenersAdded);
            entry.listenersRemoved.clear();
            entry.listenersAdded.clear();
            entry.isNotifyingListeners = false;
            if (entry.listeners.isEmpty()) {
                this.listenerMap.remove(dataKey);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    @Override
    public <V> V get(DataKey<V> key) {
        return (V)this.cache.get(key);
    }

    @Override
    public <T> void addDataChangeListener(DataKey<T> key, Runnable listener) {
        ListenerMapEntry entry = this.listenerMap.computeIfAbsent(key, k -> new ListenerMapEntry());
        if (entry.isNotifyingListeners) {
            entry.listenersRemoved.remove(listener);
            entry.listenersAdded.add(listener);
        } else {
            entry.listeners.add(listener);
        }
    }

    @Override
    public <T> void removeDataChangeListener(DataKey<T> key, Runnable listener) {
        ListenerMapEntry entry = this.listenerMap.get(key);
        if (entry != null) {
            if (entry.isNotifyingListeners) {
                entry.listenersAdded.remove(listener);
                entry.listenersRemoved.add(listener);
            } else {
                entry.listeners.remove(listener);
                if (entry.listeners.isEmpty()) {
                    this.listenerMap.remove(key);
                }
            }
        }
    }

    public boolean hasListeners(DataKey<?> key) {
        return this.listenerMap.containsKey(key);
    }

    private static class ListenerMapEntry {
        private final Set<Runnable> listeners = Sets.newConcurrentHashSet();
        private boolean isNotifyingListeners = false;
        private final Set<Runnable> listenersAdded = new HashSet<Runnable>();
        private final Set<Runnable> listenersRemoved = new HashSet<Runnable>();
    }
}

