/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.data.api;

import de.codecrafter47.data.api.DataAccess;
import de.codecrafter47.data.api.DataKey;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class AbstractDataAccess<B>
implements DataAccess<B> {
    private final Map<String, BiFunction<B, DataKey<?>, ?>> providers = new HashMap();

    protected <V> void addProvider(DataKey<V> dataKey, Function<B, V> provider) {
        this.addProvider(dataKey, (B b, K k) -> provider.apply(b));
    }

    protected <V, K extends DataKey<V>> void addProvider(DataKey<V> dataKey, BiFunction<B, K, V> provider) {
        this.providers.put(dataKey.getId(), provider);
    }

    @Override
    @Nullable
    public <V> V get(DataKey<V> key, B context) {
        BiFunction<B, DataKey<?>, ?> function = this.providers.get(key.getId());
        if (function != null) {
            return (V)function.apply(context, key);
        }
        return null;
    }

    @Override
    public boolean provides(DataKey<?> key) {
        return this.providers.containsKey(key.getId());
    }
}

