/*
 * Decompiled with CFR 0.152.
 */
package net.pekkit.actionbarbroadcast.locale;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.ChatPaginator;

public class MessageSender {
    private static final String prefix = "&f[&5ActionBarBroadcast&f] ";

    public static void sendMsg(CommandSender sender, String msg, boolean pagination) {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        if (message.length() > 55 && pagination) {
            String[] multiline = ChatPaginator.wordWrap((String)message, (int)55);
            sender.sendMessage(multiline);
        } else {
            sender.sendMessage(message);
        }
    }

    public static void sendMsg(CommandSender sender, String msg) {
        MessageSender.sendMsg(sender, msg, true);
    }

    public static void sendPluginMsg(CommandSender sender, String msg, boolean pagination) {
        MessageSender.sendMsg(sender, prefix + msg, pagination);
    }

    public static void log(String msg) {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + msg)));
    }

    public static void logStackTrace(String msg, Exception ex) {
        MessageSender.log("&4An error occured: &f" + msg);
        MessageSender.log(ex.getClass().getName());
        for (StackTraceElement ee : ex.getStackTrace()) {
            MessageSender.log("   at " + ee.getClassName() + ":" + ee.getMethodName() + " (line " + ee.getLineNumber() + ")");
        }
    }
}

