/*
 * Decompiled with CFR 0.152.
 */
package net.pekkit.actionbarbroadcast.commands;

import java.io.File;
import java.io.IOException;
import net.pekkit.actionbarbroadcast.ActionBarBroadcast;
import net.pekkit.actionbarbroadcast.BroadcastManager;
import net.pekkit.actionbarbroadcast.locale.MessageSender;
import net.pekkit.actionbarbroadcast.util.ActionUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BaseCommandExecutor
implements CommandExecutor {
    private final ActionBarBroadcast plugin;
    private final BroadcastManager bm;

    public BaseCommandExecutor(ActionBarBroadcast par1, BroadcastManager par2) {
        this.plugin = par1;
        this.bm = par2;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("ab")) {
            this.baseCommand(command, sender, args);
        } else if (command.getName().equalsIgnoreCase("broadcast")) {
            this.broadcastCommand(command, sender, args);
        }
        return true;
    }

    public void baseCommand(Command command, CommandSender sender, String[] args) {
        if (args.length < 1) {
            MessageSender.sendMsg(sender, "&5ActionBarBroadcast &d" + this.plugin.getDescription().getVersion() + ", &5created by &dSquawkers13");
            MessageSender.sendMsg(sender, "&5Type &d/ab ? &5for help.");
        } else if (args[0].equalsIgnoreCase("?")) {
            this.helpCommand(sender);
        } else if (args[0].equalsIgnoreCase("broadcast") || args[0].equalsIgnoreCase("b")) {
            this.broadcastCommand(command, sender, args);
        } else if (args[0].equalsIgnoreCase("reload") || args[0].equalsIgnoreCase("r")) {
            this.reloadCommand(sender);
        } else {
            MessageSender.sendMsg(sender, "&5I'm not sure what you mean: &d" + args[0]);
            MessageSender.sendMsg(sender, "&5Type &d/ab ?&b for help.");
        }
    }

    public void helpCommand(CommandSender sender) {
        MessageSender.sendMsg(sender, "&9---------- &5ActionBarBroadcast: &dHelp &9----------");
        if (sender.hasPermission("actionbarbroadcast.broadcast")) {
            MessageSender.sendMsg(sender, "&5/ab &db,broadcast &9[message] &5- Broadcast a message to all online players.");
        }
        if (sender.hasPermission("actionbarbroadcast.reload")) {
            MessageSender.sendMsg(sender, "&5/ab &dr,reload &5- Reload the plugin's configuration.");
        }
    }

    public void broadcastCommand(Command command, CommandSender sender, String[] args) {
        if (!sender.hasPermission("actionbarbroadcast.broadcast")) {
            MessageSender.sendMsg(sender, "&cYou don't have permission to do that!");
            return;
        }
        int i = 0;
        if (command.getName().equalsIgnoreCase("ab")) {
            if (args.length < 2) {
                MessageSender.sendMsg(sender, "&5Broadcasts a message to all online players.");
                MessageSender.sendMsg(sender, "&d/ab &dbroadcast &9[message]");
                return;
            }
        } else if (command.getName().equalsIgnoreCase("broadcast")) {
            if (args.length < 1) {
                MessageSender.sendMsg(sender, "&5Broadcasts a message to all online players.");
                MessageSender.sendMsg(sender, "&5/broadcast &9[message]");
                return;
            }
            i = 1;
        }
        StringBuilder sb = new StringBuilder();
        for (String msg : args) {
            if (i != 0) {
                sb.append(msg).append(" ");
            }
            ++i;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionUtils.sendTitle(player, sb.toString(), null);
        }
        MessageSender.sendMsg(sender, "&5Message broadcasted sucessfully.");
    }

    public void reloadCommand(CommandSender sender) {
        if (!sender.hasPermission("actionbarbroadcast.reload")) {
            MessageSender.sendMsg(sender, "&cYou don't have permission to do that!");
            return;
        }
        this.bm.stop();
        this.plugin.reloadConfig();
        if (this.plugin.getConfig() == null) {
            this.plugin.saveResource("config.yml", true);
        }
        if (this.plugin.getConfig().getDouble("settings.config-version", -1.0) != 1.1) {
            String old = this.plugin.getConfig().getString("settings.config-version", "OLD");
            MessageSender.sendMsg(sender, "&cIncompatible config detected! Renaming it to config-" + old + ".yml");
            MessageSender.sendMsg(sender, "&cA new config has been created, please transfer your settings.");
            MessageSender.sendMsg(sender, "&cWhen you have finished, type &6/ab reload&c to load your settings.");
            try {
                this.plugin.getConfig().save(new File(this.plugin.getDataFolder(), "config-" + old + ".yml"));
            }
            catch (IOException ex) {
                MessageSender.logStackTrace("Error while renaming config!", ex);
            }
            this.plugin.saveResource("config.yml", true);
        } else {
            MessageSender.sendMsg(sender, "&5Config successfully reloaded.");
        }
        this.bm.startBroadcasting();
    }
}

