/*
 * Decompiled with CFR 0.152.
 */
package net.pekkit.actionbarbroadcast;

import java.util.ArrayList;
import net.pekkit.actionbarbroadcast.ActionBarBroadcast;
import net.pekkit.actionbarbroadcast.util.ActionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BroadcastManager {
    private ActionBarBroadcast plugin;
    private TaskBroadcast task;

    public BroadcastManager(ActionBarBroadcast par1) {
        this.plugin = par1;
    }

    public void startBroadcasting() {
        int delay = this.plugin.getConfig().getInt("settings.broadcast.duration", 60) * 20;
        this.task = new TaskBroadcast(delay);
        this.task.runTaskTimer((Plugin)this.plugin, 0L, delay);
    }

    public void stop() {
        this.task.cancel();
    }

    private void setBar(String message, int d) {
        String msg = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        for (Player p : Bukkit.getOnlinePlayers()) {
            String m = msg.replaceAll("%player%", p.getName());
            ActionUtils.sendActionBar(p, m);
        }
    }

    private class TaskBroadcast
    extends BukkitRunnable {
        private int delay;
        private ArrayList<String> messages;

        public TaskBroadcast(int d) {
            this.delay = d / 20;
            this.messages = new ArrayList(BroadcastManager.this.plugin.getConfig().getStringList("settings.broadcast.messages"));
        }

        public void run() {
            String message = this.messages.get(0);
            BroadcastManager.this.setBar(message, this.delay);
            this.messages.remove(0);
            this.messages.add(message);
        }
    }
}

