/*
 * Decompiled with CFR 0.152.
 */
package net.pekkit.actionbarbroadcast;

import java.io.File;
import java.io.IOException;
import net.pekkit.actionbarbroadcast.BroadcastManager;
import net.pekkit.actionbarbroadcast.commands.BaseCommandExecutor;
import net.pekkit.actionbarbroadcast.listeners.PlayerListener;
import net.pekkit.actionbarbroadcast.locale.MessageSender;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.mcstats.Metrics;

public class ActionBarBroadcast
extends JavaPlugin {
    private BroadcastManager bbh;
    private BaseCommandExecutor bce;

    public void onEnable() {
        this.saveDefaultConfig();
        if (this.getConfig().getDouble("settings.config-version", -1.0) != 1.1) {
            String old = this.getConfig().getString("settings.config-version", "OLD");
            MessageSender.log("&cIncompatible config detected! Renaming it to config-" + old + ".yml");
            MessageSender.log("&cA new config has been created, please transfer your settings.");
            MessageSender.log("&cWhen you have finished, type &6/ab reload&c to load your settings.");
            try {
                this.getConfig().save(new File(this.getDataFolder(), "config-" + old + ".yml"));
            }
            catch (IOException ex) {
                MessageSender.logStackTrace("Error while renaming config!", ex);
            }
            this.saveResource("config.yml", true);
        }
        if (this.getConfig().getBoolean("settings.general.stats")) {
            try {
                Metrics metrics = new Metrics((Plugin)this);
                metrics.start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.bbh = new BroadcastManager(this);
        this.bce = new BaseCommandExecutor(this, this.bbh);
        this.getCommand("ab").setExecutor((CommandExecutor)this.bce);
        this.getCommand("broadcast").setExecutor((CommandExecutor)this.bce);
        if (this.getConfig().getBoolean("settings.util.headers", true)) {
            MessageSender.log("Enabling tab list headers!");
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        }
        this.bbh.startBroadcasting();
    }

    public void onDisable() {
    }
}

