/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.lapismc.afkplus.AFKPlus;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntitySpawnManager {
    private final AFKPlus plugin;
    private int spawnRange;

    public EntitySpawnManager(AFKPlus plugin) {
        this.plugin = plugin;
        try {
            YamlConfiguration spigotConfig = new YamlConfiguration();
            spigotConfig.load("spigot.yml");
            this.spawnRange = spigotConfig.getConfigurationSection("world-settings").getConfigurationSection("default").getInt("mob-spawn-range", 8);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.spawnRange = 8;
        }
    }

    public boolean shouldNaturalSpawn(Location loc) {
        ArrayList<Player> playersInRange = new ArrayList<Player>();
        for (int i = -this.spawnRange; i < this.spawnRange; ++i) {
            for (int j = -this.spawnRange; j < this.spawnRange; ++j) {
                Chunk chunk = loc.getWorld().getChunkAt(loc.getChunk().getX() + i, loc.getChunk().getZ() + j);
                for (Entity e : chunk.getEntities()) {
                    Player p;
                    if (!(e instanceof Player) || (p = (Player)e).getGameMode() == GameMode.SPECTATOR) continue;
                    playersInRange.add(p);
                }
            }
        }
        if (playersInRange.size() == 0) {
            return true;
        }
        for (Player p : playersInRange) {
            if (this.plugin.getPlayer((OfflinePlayer)p).isAFK()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSpawnerSpawn(CreatureSpawner spawner) {
        double range = 16.0;
        List players = spawner.getLocation().getWorld().getPlayers();
        players.removeIf(p -> p.getGameMode().equals((Object)GameMode.SPECTATOR));
        Location centerOfSpawner = spawner.getLocation().add(0.5, -0.5, 0.5);
        boolean playerInRange = false;
        boolean playerAFK = false;
        for (Player p2 : players) {
            if (p2.getLocation().distance(centerOfSpawner) > range) continue;
            playerInRange = true;
            if (this.plugin.getPlayer((OfflinePlayer)p2).isAFK()) {
                playerAFK = true;
                continue;
            }
            playerAFK = false;
            break;
        }
        if (playerInRange && !playerAFK) {
            return true;
        }
        return !playerInRange;
    }
}

