/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.playerdata;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.lapismc.afkplus.AFKPlus;
import net.lapismc.afkplus.api.AFKActionEvent;
import net.lapismc.afkplus.api.AFKStartEvent;
import net.lapismc.afkplus.api.AFKStopEvent;
import net.lapismc.afkplus.playerdata.Permission;
import net.lapismc.afkplus.util.EssentialsAFKHook;
import net.lapismc.afkplus.util.core.compatibility.XSound;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class AFKPlusPlayer {
    private final AFKPlus plugin;
    private final UUID uuid;
    private Long lastInteract;
    private Long afkStart;
    private boolean isAFK;
    private boolean isFakeAFK;
    private boolean isInactive;
    private boolean isWarned;

    public AFKPlusPlayer(AFKPlus plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.isAFK = false;
        this.isFakeAFK = false;
        this.isInactive = false;
        this.isWarned = false;
        this.lastInteract = System.currentTimeMillis();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getName();
    }

    public void setInactive(boolean isInactive) {
        this.isInactive = isInactive;
    }

    public boolean isNotPermitted(Permission perm) {
        return !this.plugin.perms.isPermitted(this.uuid, perm.getPermission());
    }

    public void warnPlayer() {
        this.isWarned = true;
        Player p = Bukkit.getPlayer((UUID)this.uuid);
        if (p == null) {
            return;
        }
        p.sendMessage(this.getMessage("Warning"));
        this.playSound("WarningSound", XSound.ENTITY_PLAYER_LEVELUP);
    }

    public boolean isAFK() {
        return this.isAFK;
    }

    public boolean isFakeAFK() {
        return this.isAFK && this.isFakeAFK;
    }

    public Long getAFKStart() {
        return this.afkStart;
    }

    public void startAFK() {
        if (Bukkit.getPlayer((UUID)this.getUUID()) == null) {
            return;
        }
        String command = this.plugin.getConfig().getString("Commands.AFKStart");
        String message = this.getMessage("Broadcast.Start");
        AFKStartEvent event = new AFKStartEvent(this, command, message);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.broadcast(event.getBroadcastMessage().replace("{PLAYER}", this.getName()));
        this.runCommand(event.getCommand());
        this.playSound("AFKStartSound", XSound.BLOCK_ANVIL_HIT);
        this.forceStartAFK();
    }

    public void startAFK(boolean isFake) {
        this.startAFK();
        if (this.isAFK) {
            this.isFakeAFK = isFake;
        }
    }

    public void forceStartAFK() {
        Player p;
        this.afkStart = System.currentTimeMillis();
        this.isAFK = true;
        this.updateEssentialsAFKState();
        if (this.plugin.getConfig().getBoolean("IgnoreAFKPlayersForSleep") && (p = Bukkit.getPlayer((UUID)this.getUUID())) != null) {
            p.setSleepingIgnored(true);
        }
    }

    public void stopAFK() {
        if (Bukkit.getPlayer((UUID)this.getUUID()) == null) {
            return;
        }
        String command = this.plugin.getConfig().getString("Commands.AFKStop");
        String message = this.getMessage("Broadcast.Stop");
        AFKStopEvent event = new AFKStopEvent(this, command, message);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.runCommand(event.getCommand());
        String afkTime = this.plugin.prettyTime.formatDuration(this.plugin.reduceDurationList(this.plugin.prettyTime.calculatePreciseDuration(new Date(this.afkStart))));
        this.broadcast(event.getBroadcastMessage().replace("{PLAYER}", this.getName()).replace("{TIME}", afkTime));
        this.forceStopAFK();
    }

    public void forceStopAFK() {
        Player p;
        if (this.isAFK()) {
            this.recordTimeStatistic();
        }
        this.isWarned = false;
        this.isAFK = false;
        this.isFakeAFK = false;
        this.isInactive = false;
        this.interact();
        this.updateEssentialsAFKState();
        if (this.plugin.getConfig().getBoolean("IgnoreAFKPlayersForSleep") && (p = Bukkit.getPlayer((UUID)this.getUUID())) != null) {
            p.setSleepingIgnored(false);
        }
    }

    public void broadcast(String msg) {
        if (msg.isEmpty()) {
            return;
        }
        boolean vanish = this.plugin.getConfig().getBoolean("Broadcast.Vanish");
        boolean console = this.plugin.getConfig().getBoolean("Broadcast.Console");
        boolean otherPlayers = this.plugin.getConfig().getBoolean("Broadcast.OtherPlayers");
        boolean self = this.plugin.getConfig().getBoolean("Broadcast.Self");
        if (!vanish && this.isVanished()) {
            otherPlayers = false;
        }
        Player player = Bukkit.getPlayer((UUID)this.getUUID());
        if (console) {
            Bukkit.getLogger().info(msg);
        }
        if (otherPlayers) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.equals(player)) continue;
                p.sendMessage(msg);
            }
        }
        if (self) {
            player.sendMessage(msg);
        }
    }

    public void takeAction() {
        String command = this.plugin.getConfig().getString("Commands.Action");
        AFKActionEvent event = new AFKActionEvent(this, command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.forceStopAFK();
            this.runCommand(event.getCommand());
        }
    }

    public void interact() {
        if (this.isInactive) {
            return;
        }
        this.lastInteract = System.currentTimeMillis();
        if (this.isAFK && !this.isFakeAFK) {
            this.stopAFK();
        }
    }

    public boolean isVanished() {
        if (!Bukkit.getOfflinePlayer((UUID)this.getUUID()).isOnline()) {
            return false;
        }
        Player p = Bukkit.getPlayer((UUID)this.getUUID());
        for (MetadataValue meta : p.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public long getTotalTimeAFK() {
        File f = new File(this.plugin.getDataFolder(), "statistics.yml");
        if (!f.exists()) {
            return 0L;
        }
        YamlConfiguration statistics = YamlConfiguration.loadConfiguration((File)f);
        return statistics.getLong(this.getName() + ".TimeSpentAFK", 0L);
    }

    private void updateEssentialsAFKState() {
        if (!Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
            return;
        }
        EssentialsAFKHook essHook = new EssentialsAFKHook();
        essHook.setAFK(this.getUUID(), this.isAFK);
    }

    private void runCommand(String command) {
        if (command.equals("")) {
            return;
        }
        String cmd = command.replace("[PLAYER]", this.getName());
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            boolean activeState = this.isInactive;
            this.isInactive = true;
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
            this.isInactive = activeState;
        });
    }

    private String getMessage(String key) {
        return this.plugin.config.getMessage(key, Bukkit.getOfflinePlayer((UUID)this.getUUID()));
    }

    private void playSound(String pathToSound, XSound def) {
        Player p = Bukkit.getPlayer((UUID)this.getUUID());
        if (p == null || !p.isOnline()) {
            return;
        }
        String soundName = this.plugin.getConfig().getString(pathToSound);
        if ("".equals(soundName) || soundName == null) {
            return;
        }
        Optional<XSound> retrievedSound = XSound.matchXSound(soundName);
        XSound sound = retrievedSound.orElse(def);
        sound.playSound((Entity)p);
    }

    private void recordTimeStatistic() {
        File f = new File(this.plugin.getDataFolder(), "statistics.yml");
        if (!f.exists()) {
            try {
                if (!f.createNewFile()) {
                    throw new IOException("Failed to create " + f.getName());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration statistics = YamlConfiguration.loadConfiguration((File)f);
        Long currentTimeSpendAFK = statistics.getLong(this.getName() + ".TimeSpentAFK", 0L);
        Long timeAFK = System.currentTimeMillis() - this.afkStart;
        statistics.set(this.getName() + ".TimeSpentAFK", (Object)(currentTimeSpendAFK + timeAFK));
        try {
            statistics.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Runnable getRepeatingTask() {
        return () -> {
            if (Bukkit.getOfflinePlayer((UUID)this.getUUID()).isOnline()) {
                if (this.isAFK) {
                    int playersRequired = this.plugin.getConfig().getInt("ActionPlayerRequirement");
                    boolean isAtPlayerRequirement = playersRequired == 0 ? true : Bukkit.getOnlinePlayers().size() > playersRequired;
                    Integer timeToWarning = this.plugin.perms.getPermissionValue(this.uuid, Permission.TimeToWarning.getPermission());
                    Integer timeToAction = this.plugin.perms.getPermissionValue(this.uuid, Permission.TimeToAction.getPermission());
                    long secondsSinceAFKStart = (System.currentTimeMillis() - this.afkStart) / 1000L;
                    if (!timeToWarning.equals(-1) && !this.isWarned && secondsSinceAFKStart >= (long)timeToWarning.intValue()) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::warnPlayer);
                    }
                    if (!timeToAction.equals(-1) && secondsSinceAFKStart >= (long)timeToAction.intValue() && isAtPlayerRequirement) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::takeAction);
                    }
                } else {
                    Integer timeToAFK = this.plugin.perms.getPermissionValue(this.uuid, Permission.TimeToAFK.getPermission());
                    if (timeToAFK.equals(-1) || timeToAFK.equals(0)) {
                        return;
                    }
                    long secondsSinceLastInteract = (System.currentTimeMillis() - this.lastInteract) / 1000L;
                    if (secondsSinceLastInteract >= (long)timeToAFK.intValue()) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::startAFK);
                    }
                }
            }
        };
    }
}

