/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus;

import java.util.HashMap;
import java.util.UUID;
import net.lapismc.afkplus.AFKPlus;
import net.lapismc.afkplus.api.AFKMachineDetectEvent;
import net.lapismc.afkplus.playerdata.AFKPlusPlayer;
import net.lapismc.afkplus.util.EntitySpawnManager;
import net.lapismc.afkplus.util.PlayerMovementMonitoring;
import net.lapismc.afkplus.util.PlayerMovementStorage;
import net.lapismc.afkplus.util.core.commands.CommandRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AFKPlusListeners
implements Listener {
    private final AFKPlus plugin;
    private final HashMap<UUID, Location> playerLocations = new HashMap();
    private BukkitTask AfkMachineDetectionTask;
    private final EntitySpawnManager spawnManager;
    private final PlayerMovementMonitoring monitoring;

    AFKPlusListeners(AFKPlus plugin) {
        this.plugin = plugin;
        this.monitoring = new PlayerMovementMonitoring();
        this.startAFKMachineDetection();
        this.spawnManager = new EntitySpawnManager(plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).forceStopAFK();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).forceStopAFK();
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        if (this.plugin.getConfig().getBoolean("EnabledDetections.Chat")) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).interact());
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        PlayerMovementStorage movement = new PlayerMovementStorage(e);
        if (this.plugin.getConfig().getBoolean("MovementMagnitude.Enabled")) {
            double posTrigger = this.plugin.getConfig().getDouble("MovementMagnitude.PositionTrigger");
            float lookTrigger = (float)this.plugin.getConfig().getDouble("MovementMagnitude.LookTrigger");
            this.monitoring.logAndCheckMovement(e.getPlayer().getUniqueId(), movement, posTrigger, lookTrigger);
        }
        if (movement.didLook && this.plugin.getConfig().getBoolean("EnabledDetections.Look") || movement.didMove && this.plugin.getConfig().getBoolean("EnabledDetections.Move")) {
            this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).interact();
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        if (this.plugin.getConfig().getBoolean("EnabledDetections.Attack") && e.getDamager() instanceof Player) {
            Player p = (Player)e.getDamager();
            this.plugin.getPlayer((OfflinePlayer)p).interact();
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent e) {
        if (this.plugin.getConfig().getBoolean("EnabledDetections.Command")) {
            if (e.getMessage().contains("afk")) {
                return;
            }
            for (String command : CommandRegistry.getCommand("afk").getTakenAliases()) {
                if (!e.getMessage().contains(command)) continue;
                return;
            }
            this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).interact();
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (this.plugin.getConfig().getBoolean("EnabledDetections.Interact")) {
            this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).interact();
        }
    }

    @EventHandler
    public void onPlayerBlockPlace(BlockPlaceEvent e) {
        if (this.plugin.getConfig().getBoolean("EnabledDetections.BlockPlace")) {
            this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).interact();
        }
    }

    @EventHandler
    public void onPlayerBlockBreak(BlockBreakEvent e) {
        if (this.plugin.getConfig().getBoolean("EnabledDetections.BlockBreak")) {
            this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).interact();
        }
    }

    @EventHandler
    public void onPlayerMoveProtect(PlayerMoveEvent e) {
        PlayerMovementStorage movement = new PlayerMovementStorage(e);
        boolean isBumpProtected = this.isMovementCausedByEntityBump(e.getPlayer());
        if (isBumpProtected && this.plugin.getPlayer((OfflinePlayer)e.getPlayer()).isAFK() && movement.didMove && !movement.didLook && movement.to.getY() <= movement.from.getY()) {
            e.setCancelled(true);
        }
    }

    private boolean isMovementCausedByEntityBump(Player p) {
        double requiredDistance = 0.5;
        if (!this.plugin.getConfig().getBoolean("Protections.Bump") && !this.plugin.getConfig().getBoolean("Protections.HurtByMob")) {
            return false;
        }
        boolean playerAttacked = false;
        EntityDamageEvent event = p.getLastDamageCause();
        Entity damager = null;
        if (event instanceof EntityDamageByEntityEvent) {
            damager = ((EntityDamageByEntityEvent)event).getDamager();
        }
        boolean isEntityClose = false;
        for (Entity e : p.getNearbyEntities(requiredDistance, requiredDistance, requiredDistance)) {
            if (!(e instanceof Monster) && !(e instanceof Player)) continue;
            if (e.equals(damager)) {
                playerAttacked = true;
            }
            isEntityClose = true;
            break;
        }
        if (this.plugin.getConfig().getBoolean("Protections.Bump") && isEntityClose) {
            return true;
        }
        return this.plugin.getConfig().getBoolean("Protections.HurtByMob") && (playerAttacked || isEntityClose);
    }

    @EventHandler
    public void onEntityDamageProtection(EntityDamageByEntityEvent e) {
        boolean damageCausedByPlayer = e.getDamager() instanceof Player;
        if (e.getDamager() instanceof Arrow) {
            damageCausedByPlayer = ((Arrow)e.getDamager()).getShooter() instanceof Player;
        }
        if (e.getEntity() instanceof Player && this.plugin.getPlayer((OfflinePlayer)((Player)e.getEntity())).isAFK()) {
            if (this.plugin.getConfig().getBoolean("Protections.HurtByPlayer") && damageCausedByPlayer) {
                e.setCancelled(true);
            }
            if (this.plugin.getConfig().getBoolean("Protections.HurtByMob") && !damageCausedByPlayer) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerHurt(EntityDamageEvent e) {
        if (e instanceof EntityDamageByEntityEvent || !(e.getEntity() instanceof Player)) {
            return;
        }
        AFKPlusPlayer p = this.plugin.getPlayer(e.getEntity().getUniqueId());
        if (this.plugin.getConfig().getBoolean("Protections.HurtByOther") && p.isAFK()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onNaturalMonsterSpawn(CreatureSpawnEvent e) {
        if (!this.plugin.getConfig().getBoolean("Protections.MobSpawning")) {
            return;
        }
        if (!(e.getEntity() instanceof Monster) || !e.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL)) {
            return;
        }
        boolean shouldSpawn = this.spawnManager.shouldNaturalSpawn(e.getLocation());
        if (!shouldSpawn) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSpawnerMonsterSpawn(SpawnerSpawnEvent e) {
        if (!this.plugin.getConfig().getBoolean("Protections.MobSpawning")) {
            return;
        }
        if (!(e.getEntity() instanceof Monster)) {
            return;
        }
        boolean shouldSpawn = this.spawnManager.shouldSpawnerSpawn(e.getSpawner());
        if (!shouldSpawn) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetLivingEntityEvent e) {
        if (!this.plugin.getConfig().getBoolean("Protections.MobTargeting")) {
            return;
        }
        if (!(e.getEntity() instanceof Monster)) {
            return;
        }
        if (!(e.getTarget() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getTarget();
        if (player == null) {
            return;
        }
        if (!this.plugin.getPlayer((OfflinePlayer)player).isAFK()) {
            return;
        }
        e.setCancelled(true);
    }

    public BukkitTask getAfkMachineDetectionTask() {
        return this.AfkMachineDetectionTask;
    }

    private void startAFKMachineDetection() {
        this.AfkMachineDetectionTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            this.playerLocations.clear();
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.playerLocations.put(p.getUniqueId(), p.getLocation());
            }
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
                for (UUID uuid : this.playerLocations.keySet()) {
                    if (!Bukkit.getOfflinePlayer((UUID)uuid).isOnline()) continue;
                    Location savedLoc = this.playerLocations.get(uuid);
                    Location loc = Bukkit.getPlayer((UUID)uuid).getLocation();
                    boolean inactive = false;
                    if (this.plugin.getConfig().getBoolean("AggressiveAFKDetection")) {
                        if (this.checkRotation(savedLoc, loc)) {
                            inactive = true;
                        }
                        if (this.checkTransform(savedLoc, loc)) {
                            inactive = true;
                        }
                    } else if ((this.checkRotation(savedLoc, loc) ? 1 : 0) + (this.checkTransform(savedLoc, loc) ? 1 : 0) == 1) {
                        inactive = true;
                    }
                    if (inactive) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new AFKMachineDetectEvent(this.plugin.getPlayer(uuid))));
                    }
                    this.plugin.getPlayer(uuid).setInactive(inactive);
                }
            }, 40L);
        }, 100L, 100L);
    }

    private boolean checkRotation(Location oldLoc, Location newLoc) {
        boolean yaw = oldLoc.getYaw() == newLoc.getYaw();
        boolean pitch = oldLoc.getPitch() == newLoc.getPitch();
        return yaw && pitch;
    }

    private boolean checkTransform(Location oldLoc, Location newLoc) {
        boolean x = oldLoc.getX() == newLoc.getX();
        boolean y = oldLoc.getY() == newLoc.getY();
        boolean z = oldLoc.getZ() == newLoc.getZ();
        return x && y && z;
    }
}

