/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.lapismc.afkplus.AFKPlusListeners;
import net.lapismc.afkplus.AFKPlusPermissions;
import net.lapismc.afkplus.api.AFKPlusAPI;
import net.lapismc.afkplus.api.AFKPlusPlayerAPI;
import net.lapismc.afkplus.commands.AFK;
import net.lapismc.afkplus.commands.AFKPlusCmd;
import net.lapismc.afkplus.playerdata.AFKPlusPlayer;
import net.lapismc.afkplus.util.AFKPlusContext;
import net.lapismc.afkplus.util.core.LapisCoreConfiguration;
import net.lapismc.afkplus.util.core.LapisCorePlugin;
import net.lapismc.afkplus.util.core.utils.LapisCoreFileWatcher;
import net.lapismc.afkplus.util.core.utils.LapisUpdater;
import net.lapismc.afkplus.util.core.utils.Metrics;
import net.lapismc.afkplus.util.prettytime.Duration;
import net.lapismc.afkplus.util.prettytime.PrettyTime;
import net.lapismc.afkplus.util.prettytime.units.JustNow;
import net.lapismc.afkplus.util.prettytime.units.Millisecond;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public final class AFKPlus
extends LapisCorePlugin {
    public PrettyTime prettyTime;
    public LapisUpdater updater;
    private final HashMap<UUID, AFKPlusPlayer> players = new HashMap();
    private AFKPlusListeners listeners;

    public void onEnable() {
        this.saveDefaultConfig();
        this.registerConfiguration(new LapisCoreConfiguration(this, 11, 2));
        this.registerPermissions(new AFKPlusPermissions(this));
        this.registerLuckPermsContext();
        this.update();
        LapisCoreFileWatcher fileWatcher = new LapisCoreFileWatcher(this);
        this.tasks.addShutdownTask(fileWatcher::stop);
        Locale loc = new Locale(this.config.getMessage("PrettyTimeLocale"));
        this.prettyTime = new PrettyTime(loc);
        this.prettyTime.removeUnit(JustNow.class);
        this.prettyTime.removeUnit(Millisecond.class);
        new AFK(this);
        new AFKPlusCmd(this);
        this.listeners = new AFKPlusListeners(this);
        new AFKPlusAPI(this);
        new AFKPlusPlayerAPI(this);
        new Metrics((Plugin)this);
        this.tasks.addShutdownTask(() -> {
            this.players.values().forEach(AFKPlusPlayer::forceStopAFK);
            this.players.clear();
        });
        this.tasks.addTask(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this.getRepeatingTasks(), 20L, 20L));
        this.getLogger().info(this.getName() + " v." + this.getDescription().getVersion() + " has been enabled!");
    }

    @Override
    public void onDisable() {
        this.tasks.stopALlTasks();
        this.listeners.getAfkMachineDetectionTask().cancel();
        this.getLogger().info(this.getName() + " has been disabled!");
    }

    public AFKPlusPlayer getPlayer(UUID uuid) {
        if (!this.players.containsKey(uuid)) {
            this.players.put(uuid, new AFKPlusPlayer(this, uuid));
        }
        return this.players.get(uuid);
    }

    public AFKPlusPlayer getPlayer(OfflinePlayer op) {
        return this.getPlayer(op.getUniqueId());
    }

    private void update() {
        this.updater = new LapisUpdater(this, "AFKPlus", "Dart2112", "AFKPlus", "master");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            if (this.updater.checkUpdate()) {
                if (this.getConfig().getBoolean("UpdateDownload")) {
                    this.updater.downloadUpdate();
                } else {
                    this.getLogger().info(this.config.getMessage("Updater.UpdateFound"));
                }
            } else {
                this.getLogger().info(this.config.getMessage("Updater.NoUpdate"));
            }
        });
    }

    private void registerLuckPermsContext() {
        if (this.getServer().getPluginManager().getPlugin("LuckPerms") != null) {
            new AFKPlusContext();
        }
    }

    private Runnable getRepeatingTasks() {
        return () -> {
            for (AFKPlusPlayer player : this.players.values()) {
                player.getRepeatingTask().run();
            }
        };
    }

    public List<Duration> reduceDurationList(List<Duration> durationList) {
        while (durationList.size() > 2) {
            Duration smallest = null;
            for (Duration current : durationList) {
                if (smallest != null && smallest.getUnit().getMillisPerUnit() <= current.getUnit().getMillisPerUnit()) continue;
                smallest = current;
            }
            durationList.remove(smallest);
        }
        return durationList;
    }
}

