/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.util;

import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import net.lapismc.afkplus.AFKPlus;
import net.lapismc.afkplus.util.PlayerMovementStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerMovementMonitoring {
    private final HashMap<UUID, RollingLocations> playerRollingTotals = new HashMap();

    public PlayerMovementMonitoring() {
        AFKPlus.getInstance().tasks.addTask(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)AFKPlus.getInstance(), this.getRepeatingTask(), 5L, 5L));
    }

    public void logAndCheckMovement(UUID uuid, PlayerMovementStorage movement, double posTrigger, float lookTrigger) {
        this.logMovement(uuid, movement.to);
        RollingLocations locs = this.getPlayerRollingTotal(uuid);
        if (movement.didMove) {
            movement.didMove = locs.checkPosition(posTrigger);
        }
        if (movement.didLook) {
            movement.didLook = locs.checkLook(lookTrigger);
        }
    }

    public void logMovement(UUID uuid, Location loc) {
        RollingLocations locs = this.getPlayerRollingTotal(uuid);
        locs.addLocation(loc);
    }

    private RollingLocations getPlayerRollingTotal(UUID uuid) {
        if (!this.playerRollingTotals.containsKey(uuid)) {
            this.playerRollingTotals.put(uuid, new RollingLocations());
        }
        return this.playerRollingTotals.get(uuid);
    }

    private Runnable getRepeatingTask() {
        return () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                RollingLocations locs = this.getPlayerRollingTotal(p.getUniqueId());
                long allowedTime = 100L;
                if (locs.time + allowedTime >= new Date().getTime()) continue;
                this.logMovement(p.getUniqueId(), p.getLocation());
            }
        };
    }

    private static class RollingLocations {
        private final int samples = 10;
        private final Location[] locations = new Location[10];
        private int i = 0;
        protected long time;

        private RollingLocations() {
        }

        public void addLocation(Location l) {
            this.time = new Date().getTime();
            this.locations[this.i] = l;
            ++this.i;
            if (this.i == 10) {
                this.i = 0;
            }
        }

        public boolean checkPosition(double trigger) {
            double totalMovement = 0.0;
            for (int j = 1; j < this.locations.length; ++j) {
                Location to = this.locations[j];
                Location from = this.locations[j - 1];
                if (to == null || from == null) {
                    if (totalMovement != 0.0) continue;
                    return false;
                }
                try {
                    totalMovement += to.distanceSquared(from);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    return true;
                }
            }
            return (totalMovement = Math.sqrt(totalMovement)) >= trigger;
        }

        public boolean checkLook(float trigger) {
            float totalLookAngle = 0.0f;
            for (int j = 1; j < this.locations.length; ++j) {
                Location to = this.locations[j];
                Location from = this.locations[j - 1];
                if (to == null || from == null) {
                    if (totalLookAngle != 0.0f) continue;
                    return false;
                }
                totalLookAngle += to.getDirection().angle(from.getDirection());
            }
            return totalLookAngle > trigger;
        }
    }
}

