/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.commands;

import java.util.ArrayList;
import net.lapismc.afkplus.AFKPlus;
import net.lapismc.afkplus.playerdata.AFKPlusPlayer;
import net.lapismc.afkplus.playerdata.Permission;
import net.lapismc.afkplus.util.AFKPlusCommand;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class AFKPlusCmd
extends AFKPlusCommand {
    public AFKPlusCmd(AFKPlus plugin) {
        super(plugin, "afkplus", "Shows plugin, player and help information", new ArrayList<String>());
    }

    @Override
    protected void onCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            String primary = this.plugin.primaryColor;
            String secondary = this.plugin.secondaryColor;
            String bars = secondary + "-------------";
            sender.sendMessage(bars + primary + "   AFKPlus   " + bars);
            sender.sendMessage(primary + "Version: " + secondary + this.plugin.getDescription().getVersion());
            sender.sendMessage(primary + "Author: " + secondary + (String)this.plugin.getDescription().getAuthors().get(0));
            sender.sendMessage(primary + "Spigot: " + secondary + "https://goo.gl/yeMGBL");
            sender.sendMessage(primary + "If you need help use " + secondary + "/afkplus help");
            sender.sendMessage(bars + bars + bars);
        } else if (args.length == 1) {
            if (args[0].equalsIgnoreCase("update")) {
                if (this.isNotPermitted(sender, Permission.CanUpdate)) {
                    this.sendMessage(sender, "Error.NotPermitted");
                    return;
                }
                if (this.plugin.updater.checkUpdate()) {
                    this.sendMessage(sender, "Updater.UpdateDownloading");
                    this.plugin.updater.downloadUpdate();
                } else {
                    this.sendMessage(sender, "Updater.NoUpdate");
                }
            } else if (!args[0].equalsIgnoreCase("player")) {
                this.sendHelp(sender);
            }
        } else if (args[0].equalsIgnoreCase("player")) {
            this.playerCommand(sender, args);
        } else {
            this.sendHelp(sender);
        }
    }

    private void sendHelp(CommandSender sender) {
        YamlConfiguration messages = this.plugin.config.getMessages();
        sender.sendMessage(this.plugin.config.getMessage("Help.Help"));
        for (String key : messages.getConfigurationSection("Help").getKeys(false)) {
            if (key.equalsIgnoreCase("help")) continue;
            this.sendMessage(sender, "Help." + key);
        }
    }

    private void playerCommand(CommandSender sender, String[] args) {
        if (args.length == 2) {
            String name = args[1];
            OfflinePlayer op = Bukkit.getOfflinePlayer((String)name);
            if (!op.hasPlayedBefore()) {
                this.sendMessage(sender, "Error.PlayerNotFound");
                return;
            }
            AFKPlusPlayer player = this.getPlayer(op);
            if (player.isAFK()) {
                Long afkStart = player.getAFKStart();
                String message = this.plugin.config.getMessage("Player.AFK").replace("{PLAYER}", player.getName()).replace("{TIME}", this.getTimeDifference(afkStart));
                sender.sendMessage(message);
            } else {
                String message = this.plugin.config.getMessage("Player.NotAFK").replace("{PLAYER}", player.getName());
                sender.sendMessage(message);
            }
        } else {
            this.sendMessage(sender, "Help.AFKPlusPlayer");
        }
    }
}

