/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.commands;

import java.util.ArrayList;
import net.lapismc.afkplus.AFKPlus;
import net.lapismc.afkplus.playerdata.AFKPlusPlayer;
import net.lapismc.afkplus.playerdata.Permission;
import net.lapismc.afkplus.util.AFKPlusCommand;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AFK
extends AFKPlusCommand {
    public AFK(AFKPlus plugin) {
        super(plugin, "afk", "Toggle AFK status", new ArrayList<String>());
    }

    @Override
    protected void onCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            if (this.isNotPlayer(sender, "Error.MustBePlayer")) {
                return;
            }
            AFKPlusPlayer player = this.getPlayer((OfflinePlayer)((Player)sender));
            if (player.isNotPermitted(Permission.AFKSelf)) {
                this.sendMessage(sender, "Error.NotPermitted");
                return;
            }
            this.toggleAFK(player);
        } else if (args.length == 1) {
            if (args[0].equalsIgnoreCase("-fake")) {
                if (this.isNotPlayer(sender, "Error.MustBePlayer")) {
                    return;
                }
                if (this.isNotPermitted(sender, Permission.FakeAFK)) {
                    this.sendMessage(sender, "Error.NotPermitted");
                    return;
                }
                this.toggleFakeAFK(this.getPlayer((OfflinePlayer)((Player)sender)));
                return;
            }
            if (this.isNotPermitted(sender, Permission.AFKOthers)) {
                this.sendMessage(sender, "Error.NotPermitted");
                return;
            }
            OfflinePlayer op = Bukkit.getOfflinePlayer((String)args[0]);
            if (!op.isOnline()) {
                this.sendMessage(sender, "Error.PlayerNotFound");
                return;
            }
            this.toggleAFK(this.getPlayer(op));
        } else {
            this.sendMessage(sender, "Help.AFK");
        }
    }

    private void toggleAFK(AFKPlusPlayer player) {
        if (player.isAFK()) {
            player.stopAFK();
        } else {
            player.startAFK();
        }
    }

    private void toggleFakeAFK(AFKPlusPlayer player) {
        if (player.isFakeAFK()) {
            player.stopAFK();
        } else {
            player.startAFK(true);
        }
    }
}

